<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\MpesaController;

Route::middleware(['auth:sanctum'])->get('/user', function (Request $request) {
    return $request->user();
});

// Initiate STK Push (Public – No Auth)
Route::post('/mpesa/initiate', [MpesaController::class, 'initiateStk'])
    ->withoutMiddleware(['auth:sanctum'])
    ->name('mpesa.initiate');

// Safaricom Callback URL (Must be Public)
Route::post('/mpesa/callback', [MpesaController::class, 'callbackResponse'])
    ->withoutMiddleware(['auth:sanctum'])
    ->name('mpesa.callback');
