<?php

namespace App\Services;

use Carbon\Carbon;
use Illuminate\Support\Facades\Http;

class MpesaService
{
    protected $baseUrl;

    

    public function __construct()
    {
        $this->baseUrl = env('MPESA_ENV') === 'production'
            ? "https://api.safaricom.co.ke"
            : "https://sandbox.safaricom.co.ke";
            
    }

   public function generateAccessToken()
    {
        $key = env('MPESA_CONSUMER_KEY');
        $secret = env('MPESA_CONSUMER_SECRET');

        $url = $this->baseUrl . "/oauth/v1/generate?grant_type=client_credentials";

        $response = Http::withBasicAuth($key, $secret)->get($url);

        return $response->json()['access_token'];
    }

    public function generateStkPassword()
    {
        $shortcode = env("MPESA_SHORT_CODE");
        $passkey = env('MPESA_PASSKEY');
        $timestamp = now()->format('YmdHis');

        $password = base64_encode($shortcode . $passkey . $timestamp);

        return [
            'password' => $password,
            'timestamp' => $timestamp,  
        ];
    }

  public function stkPush($phone, $amount, $reference, $description,$callbackUrl)
    {
        // 1. Generate access token
        $token = $this->generateAccessToken();

        // 2. Generate password + timestamp
        $stk = $this->generateStkPassword();
        $password = $stk['password'];
        $timestamp = $stk['timestamp'];

        // 3. Get configuration values
        $shortcode = env("MPESA_SHORT_CODE");
        
        // 4. STK push endpoint
        $url = $this->baseUrl . "/mpesa/stkpush/v1/processrequest";

        // 5. Build request body
        $body = [
            "BusinessShortCode" => $shortcode,
            "Password"          => $password,
            "Timestamp"         => $timestamp,
            "TransactionType"   => "CustomerPayBillOnline",
            "Amount"            => $amount,
            "PartyA"            => $phone,
            "PartyB"            => $shortcode,
            "PhoneNumber"       => $phone,
            "CallBackURL"       => $callbackUrl,
            "AccountReference"  => $reference,
            "TransactionDesc"   => $description
        ];

        // 6. Send request
        $response = Http::withToken($token)
            ->post($url, $body);

        // 7. Return Safaricom response as JSON
        return $response->json();
    }


}
