<?php

namespace App\Http\Controllers;

use App\Services\MpesaService;
use Illuminate\Http\Request;

class MpesaController extends Controller
{
    protected $mpesa;

    public function __construct(MpesaService $mpesa)
    {
        $this->mpesa = $mpesa;
    }

    public function initiateStk(Request $request)
    {
        $request->validate([
            "phone"          => 'required',
            "amount"         => 'required|numeric',
            "payment_reason" => 'nullable|string'
        ]);

        $callbackUrl = route("mpesa.callback");
        $reference   = "ORDER-" . rand(1000, 9999);
        $description = $request->payment_reason ?? "Payment";

        // Correct argument order
        $response = $this->mpesa->stkPush(
            $request->phone,
            $request->amount,
            $reference,
            $description,
            $callbackUrl
        );

        return response()->json($response);
    }

   public function callbackResponse(Request $request)
    {
        $callback = $request->json('Body.stkCallback');

        if (!isset($callback['CallbackMetadata']['Item'])) {
            return response()->json([
                'ResultCode' => 1,
                'ResultDesc' => 'No metadata found'
            ]);
        }

        $items = $callback['CallbackMetadata']['Item'];

        // Convert Safaricom array into key/value pairs like:
        // ["Amount" => 10, "MpesaReceiptNumber" => "ABC123", ...]
        $data = [];
        foreach ($items as $item) {
            $name  = $item['Name'];
            $value = $item['Value'] ?? null;
            $data[$name] = $value;
        }

        return response()->json([
            'status' => 200,
            'message' => 'Callback received successfully',
            'data' => $data
        ]);
    }

}
